/* Filename: WINS.H
   Yet another simulator of the windows environment.
   from Jason.  TADA!  10-4-96, over.

   OBJECTS 0-40 are RESERVED for OPTION BUTTONS;
   OBJECTS 41-120 are for Check Boxes and/or Push Buttons.

   SETOBJ(Window, Type, Number, Text, X, Y, State);
*/

#include <dos.h>
#include <mouse.h>
#include <graphics.h>

#define  centerl(p)   len/2 -(strlen(p)*6/2 +5)
#define  centerw      wid/2

#define  left         6
#define  top          20

#define  right(p)     len-(strlen(p)*6 +15)
#define  bottom       wid-19

#define  SET          1
#define  RESET        0
#define  GRAY_SET    -1
#define  GRAY_RESET  -2

#define  PUSH         1
#define  OPTN         2
#define  CHCK         3
#define  LABL         4
#define  TXTB         5
#define  GRPB         6
#define  PICT         7

#define  ACTIVEC      2
#define  INACTIVEC    4

typedef struct OBJ {
	char txt[80];
	int x;
	int y;
	int s;
	int winl;
	int Q;
} object;

typedef struct OB2 {
	char txt[40];
	int x,y,x2,y2;
	int winl;
	int Q;
} object2;

typedef struct WD {
	char ttl[80];
	int x;
	int y;
	int len;
	int wid;
	int num;
} window;

int active=0,ww=0;

int mde=0;

void setobj(int w,int Q,int n,char txt[],int x,int y,int s);
void setobj2(int w,int Q,int n,char txt[],int x,int y,int x2,int y2);
void newwin(int num,char ttl[],int x,int y,int len,int wid);
void drwwin(window w);
void clrwin(window w);
void paint(int x,int y,int clr,int bdr);
void drwpsh(object  p,window w);
void drwchk(object  c,window w);
void drwopt(object  o,window w);
void drwlbl(object  o,window w);
void drwtxt(object  t,window w);
void drwgrp(object2 g,window w);
void drwpic(object  p,window w);

void putms(int x,int y);
void getms(int x,int y);
void erasems(int x,int y);
void inits(int q);

void waitck(int *x,int *y);    // Pointers to return click coords (use &)
int state(int n);
char *text(int n);

int  world();
void wmove(window *w2);
int  wwait(window *w2);

void intSVGA(int mde2);
int huge detectSVGA(void);
void setrgb(int x,int r,int g,int b);

void intSVGA(int mde2)
{
   int gdriver, gmode;
   mde=mde2;
   gdriver = installuserdriver("SVGA256", detectSVGA);
   gdriver = DETECT;
   initgraph(&gdriver, &gmode, "");
}

int huge detectSVGA(void)
{
	  return mde;
}

void setrgb(int x,int r,int g,int b)
{
	outportb(0x3C8,x);
	outportb(0x3C9,r);
	outportb(0x3C9,g);
	outportb(0x3C9,b);
	return;
}

int ms[300],ms2[300];

window  ws[30];
object  os[120];
object2 os2[30];

void setobj(int w,int Q,int n,char txt[],int x,int y,int s)
{
	os[n].x=-1;
	if (n<40&&Q!=OPTN) return;  // Not Option button and <40
	if (n>39&&Q==OPTN) return;  // Option button and not <40
	strcpy(os[n].txt,txt);
	os[n].Q=Q; os[n].x=x;
	os[n].y=y; os[n].winl=w;
	os[n].s=s;
}

void setobj2(int w,int Q,int n,char txt[],int x,int y,int x2,int y2)
{
	strcpy(os2[n].txt,txt);
	os2[n].winl=w;
	os2[n].Q=Q;
	os2[n].x=x; os2[n].y=y;
	os2[n].x2=x2; os2[n].y2=y2;
}

void newwin(int num,char ttl[],int x,int y,int len,int wid)
{
	strcpy(ws[ww].ttl,ttl);
	ws[ww].x=x; ws[ww].y=y;
	ws[ww].len=len; ws[ww].wid=wid;
	ws[ww].num=num;
	active=ws[ww].num;  // Set new window as active window
	ww++;
}

void drwwin(window w)
{
	int x;
	clrwin(w);
	setcolor(INACTIVEC);
	if (active==w.num) setcolor(ACTIVEC);
	rectangle(w.x,w.y,w.x+w.len,w.y+w.wid);
	rectangle(w.x+1,w.y+1,w.x+w.len-1,w.y+w.wid-1);
	paint(w.x+4,w.y+4,15,getcolor());
	rectangle(w.x+3,w.y+3,w.x+w.len-3,w.y+15);
	paint(w.x+4,w.y+4,getcolor(),getcolor());
	settextstyle(SMALL_FONT,0,4); setcolor(15);
	outtextxy(w.x+(w.len/2-(strlen(w.ttl)*6)/2),w.y+3,w.ttl);

	for (x=0;x<120;x++) {
		if (os[x].winl==w.num && os[x].x!=-1) {
			if (os[x].Q==PUSH) drwpsh(os[x],w);
			if (os[x].Q==CHCK) drwchk(os[x],w);
			if (os[x].Q==OPTN) drwopt(os[x],w);
			if (os[x].Q==LABL) drwlbl(os[x],w);
			if (os[x].Q==TXTB) drwtxt(os[x],w);
			if (os[x].Q==PICT) drwpic(os[x],w);
		}
	}
	for (x=0;x<30;x++) {
		if (os2[x].winl==w.num && os2[x].x!=-1) {
			if (os2[x].Q==GRPB) drwgrp(os2[x],w);
		}
	}
}

void clrwin(window w)
{
	int y;
	//paint(w.x+3,w.y+3,0,0);
	setcolor(0);
	for (y=w.y;y<=w.y+w.wid;y++) {
		line(w.x,y,w.x+w.len,y);
	}
}

void paint(int x,int y,int clr,int bdr)
{
	setfillstyle(SOLID_FILL,clr);
	floodfill(x,y,bdr);
}

void drwpsh(object p,window w)
{
	// Isn't it amazing to think I knew what all these numbers meant
	// when I put them in?!?

	int wid;
	wid=strlen(p.txt)*6 +8;   // Width of text + 4-pixel margin

	setcolor(7);
	outtextxy(w.x+p.x+5,w.y+p.y+1,p.txt);
	outtextxy(w.x+p.x+6,w.y+p.y+2,p.txt);

	setcolor(16);
	rectangle(w.x+p.x,w.y+p.y,w.x+p.x+wid,w.y+p.y+15);
	paint(w.x+p.x+1,w.y+p.y+1,7,16);
	putpixel(w.x+p.x,w.y+p.y,15); putpixel(w.x+p.x+wid,w.y+p.y,15);
	putpixel(w.x+p.x,w.y+p.y+15,15); putpixel(w.x+p.x+wid,w.y+p.y+15,15);
	setcolor(8);
	rectangle(w.x+p.x+1,w.y+p.y+1,w.x+p.x+wid-1,w.y+p.y+14);
	setcolor(15);
	if (p.s<=0) {  // Out
		line(w.x+p.x+1,w.y+p.y+1,w.x+p.x+wid-1,w.y+p.y+1);
		line(w.x+p.x+1,w.y+p.y+1,w.x+p.x+1,w.y+p.y+14);
	} else {       // In
		line(w.x+p.x+wid-1,w.y+p.y+1,w.x+p.x+wid-1,w.y+p.y+14);
		line(w.x+p.x+1,w.y+p.y+14,w.x+p.x+wid-1,w.y+p.y+14);
	}
	setcolor(16); if (p.s<0) setcolor(24);  // Disabled
	if (p.s<=0) {  // Out
		outtextxy(w.x+p.x+5,w.y+p.y+1,p.txt);
	} else {       // In
		outtextxy(w.x+p.x+6,w.y+p.y+2,p.txt);
	}
}

void drwchk(object c,window w)
{
	setcolor(16); if (c.s<0) setcolor(24);  // Greyed
	rectangle(c.x+w.x,c.y+w.y,c.x+w.x+10,c.y+w.y+10);
	outtextxy(c.x+w.x+15,c.y+w.y,c.txt);
	if (c.s==1||c.s==-1) {
		line(c.x+w.x+1,c.y+w.y+1,c.x+w.x+9,c.y+w.y+9);
		line(c.x+w.x+9,c.y+w.y+1,c.x+w.x+1,c.y+w.y+9);
	} else {
		setcolor(15);
		line(c.x+w.x+1,c.y+w.y+1,c.x+w.x+9,c.y+w.y+9);
		line(c.x+w.x+9,c.y+w.y+1,c.x+w.x+1,c.y+w.y+9);
	}
}

void drwopt(object o,window w)
{
	setcolor(16); if (o.s<0) setcolor(24); 
	circle(o.x+w.x+5,o.y+w.y+5,5);
	outtextxy(o.x+w.x+15,o.y+w.y,o.txt);
	if (o.s==1||o.s==-1) {
		circle(o.x+w.x+5,o.y+w.y+5,3);
		paint(o.x+w.x+5,o.y+w.y+5,getcolor(),getcolor());
	} else {
		setcolor(15);
		circle(o.x+w.x+5,o.y+w.y+5,3);
		paint(o.x+w.x+5,o.y+w.y+5,getcolor(),getcolor());
	}
}

void drwlbl(object o,window w)
{
	setcolor(o.s);
	outtextxy(o.x+w.x,o.y+w.y,o.txt);
}

void drwtxt(object t,window w)
{
	int x,y;
	char tt[80];
	setcolor(16);
	rectangle(t.x+w.x,t.y+w.y,t.x+w.x+t.s,t.y+w.y+16);
	y=(t.s-8)/6;   // How many will fit?
	for (x=0;x<y && x<strlen(t.txt);x++) tt[x]=t.txt[x];
	tt[x]='\0';  // Terminate string
	outtextxy(t.x+w.x+4,t.y+w.y+2,tt);
}

void drwgrp(object2 g,window w)
{
	int l;
	l=strlen(g.txt)*6+6;
	setcolor(16);
	rectangle(g.x+w.x,g.y+w.y,g.x2+w.x,g.y2+w.y);
	setcolor(15);
	line(g.x+w.x+5,g.y+w.y,g.x+w.x+5+l,g.y+w.y);
	setcolor(16);
	outtextxy(g.x+w.x+9,g.y+w.y-6,g.txt);
}

void drwpic(object p,window w)    // 16-color image made with GIF2PIC
{
	FILE *F;
	char fn1[60],fn2[60];
	int x,y,ex,ey,a,b,c;
	strcpy(fn1,p.txt); strcat(fn1,".PAL");
	strcpy(fn2,p.txt); strcat(fn2,".PIC");
	F=fopen(fn1,"rb");
		if (F==NULL) {fclose(F); return;}
		for (x=64;x<80;x++) {
			a=fgetc(F); b=fgetc(F); c=fgetc(F);
			setrgb(x,a,b,c);
		}
	fclose(F);
	F=fopen(fn2,"rb");
		if (F==NULL) {fclose(F); return;}
		fgets(fn1,40,F);
		sscanf(fn1,"%d %d",&ex,&ey);
		for (y=p.y+w.y;y<p.y+w.y+ey;y++) {
			for (x=p.x+w.x;x<p.x+w.x+ex;x++) {
				putpixel(x,y,fgetc(F)+64);
			}
		}
	fclose(F);
}

void putms(int x,int y)
{
	int x2,y2;
	for (y2=y;y2<y+21;y2++) {
		for (x2=x;x2<x+10;x2++) {
			if (ms2[(y2-y)*10+(x2-x)]!=0) {
				ms[(y2-y)*10+(x2-x)]=getpixel(x2,y2);
				putpixel(x2,y2,ms2[(y2-y)*10+(x2-x)]);
			}
		}
	}
}

void getms(int x,int y)
{
	int x2,y2;
	for (y2=y;y2<y+21;y2++) {
		for (x2=x;x2<x+10;x2++) {
			ms2[(y2-y)*10+(x2-x)]=getpixel(x2,y2);
		}
	}
}

void erasems(int x,int y)
{
	int x2,y2;
	for (y2=y;y2<y+21;y2++) {
		for (x2=x;x2<x+10;x2++) {
			if (ms2[(y2-y)*10+(x2-x)]!=0)
			 putpixel(x2,y2,ms[(y2-y)*10+(x2-x)]);
		}
	}
}

void waitck(int *x,int *y)
{
	int mx,my,mb;
	mx=mousex(); my=mousey(); mb=0;
	while (mb!=1) {
		mx=mousex(); my=mousey(); mb=mouseb();
		putms(mx,my);
		while (mx==mousex()&&my==mousey()&&mouseb()==0);
		delay(30);
		erasems(mx,my);
	}
	*x=mx; *y=my;       // Set return variable values
}

int state(int n)
{
	return os[n].s;
}

char *text(int n)
{
	return os[n].txt;
}

void inits(int q)
{
	int x;
	intSVGA(q);
	mouse_setup(getmaxx(),getmaxy());   // From mouse.h
	if (getmaxy()==199) mouse_setup(getmaxx(),getmaxy()-20);
	moveto(0,0); setcolor(16);
	linerel(0,13); linerel(3,-1); linerel(1,6); linerel(3,-1);
	linerel(-1,-6); linerel(3,-1); lineto(0,0);
	setfillstyle(SOLID_FILL,15); floodfill(4,8,16);
	getms(0,0); paint(0,0,0,0);       // Initialize
	for (x=0;x<120;x++) {              // Clear stuff
		os[x].x=-1;
	}
	for (x=0;x<30;x++) {
		os2[x].x=-1;
	}
	for (x=0;x<30;x++) {
		ws[x].x=-1;
	}
}

int world(void)
{
	int u,a,t,t2,mx,my,x2,y2,x3,y3;
	u=-1;
	for (t=0;ws[t].x!=-1;t++) if (active==ws[t].num) a=t;
	for (t=0;ws[t].x!=-1;t++) { if (t!=a) drwwin(ws[t]); }  // No draw active
	while (u==-1) {
		t2=wwait(&ws[a]);
		if (t2!=-1) u=t2;   // Button clicked; exit
		if (t2==-1) {
			mx=mousex(); my=mousey();
			for (t=0;ws[t].x!=-1;t++) {
				x2=ws[t].x; x3=ws[t].x+ws[t].len;
				y2=ws[t].y; y3=ws[t].y+ws[t].wid;
				if (mx>x2&&mx<x3&&my>y2&&my<y3) {   // Window clicked on
					a=t;
					active=ws[a].num;
				}
			}
			for (t=0;ws[t].x!=-1;t++) if (a!=t) drwwin(ws[t]);
		}
	}
	return u;
}

void wmove(window *w2)
{
	int x,y,mx,my;
	window w;
	w=*w2;
	mx=mousex(); my=mousey();
	clrwin(w);
	x=mx-w.x; y=my-w.y;
	while (mouseb()!=0) {
		mx=mousex(); my=mousey();
		w.x=mx-x; w.y=my-y;
		setcolor(15); rectangle(w.x,w.y,w.x+w.len,w.y+w.wid);
		  line(w.x,w.y+15,w.x+w.len,w.y+15);
		while (mousex()==mx && mousey()==my && mouseb()!=0);
		setcolor(0); rectangle(w.x,w.y,w.x+w.len,w.y+w.wid);
		  line(w.x,w.y+15,w.x+w.len,w.y+15);
	}
	if (w.x<0) w.x=0; if (w.y<0) w.y=0;    // Prevent backing off screen
	if (w.x>getmaxx()-10) w.x=getmaxx()-10; // Not off screen otherway
	if (w.y>getmaxy()-10) w.y=getmaxy()-10; // Not off screen otherway
	for (x=0;ws[x].x!=-1;x++) if (ws[x].num!=active) drwwin(ws[x]);
	drwwin(w); // Draw New Window  // Draw only old windows ^
	*w2=w;
}

int wwait(window *w2)
{
	window w;
	int nhit=-1,x,y,c,d,e;
	char u,tt[80];
	w=*w2;
	active=w.num;
	drwwin(w);
	while (nhit==-1) {
		waitck(&x,&y);
		if (x<w.x||x>w.x+w.len||y<w.y||y>w.y+w.wid) break;  // Clicked off;
		if (y>w.y && y<w.y+15 && x>w.x && x<w.x+w.len) {  // Clicked bar
			wmove(&w);
		}
		for (c=0;c<120;c++) {  // Objects
			if (os[c].winl==w.num) {
				if (x>os[c].x+w.x && x<(os[c].x+strlen(os[c].txt)*6+8+w.x)||
						os[c].Q==TXTB&&x>os[c].x+w.x&&x<os[c].x+os[c].s+w.x) {
					if (y>os[c].y+w.y&&y<os[c].y+15+w.y &&os[c].s>=0||
						os[c].Q==TXTB&&y>os[c].y+w.y&&y<os[c].y+w.y+16) {

						// The IF's above was extended for the special
						// case of the TextBox (TXTB).

						if (os[c].Q==PUSH) {
							os[c].s=1; drwpsh(os[c],w);
							while (mouseb()!=0); delay(100);
							os[c].s=0; drwpsh(os[c],w);
							nhit=c;
						}
						if (os[c].Q==CHCK) {
							if (os[c].s==0) { os[c].s=1; }
							else if (os[c].s==1) { os[c].s=0; }
							setcolor(16);   // Double wall for CheckBox
							rectangle(os[c].x+w.x+1,os[c].y+w.y+1,os[c].x+w.x+9,os[c].y+w.y+9);
							while (mouseb()!=0);
							setcolor(15);   // Erase the double wall
							rectangle(os[c].x+w.x+1,os[c].y+w.y+1,os[c].x+w.x+9,os[c].y+w.y+9);
							drwchk(os[c],w);
						}
						if (os[c].Q==OPTN) {
							os[c].s=1;
							setcolor(16);   // Double wall for OptionButton
							circle(os[c].x+w.x+5,os[c].y+w.y+5,4);
							while (mouseb()!=0);
							setcolor(15);   // Erase the double wall
							circle(os[c].x+w.x+5,os[c].y+w.y+5,4);
							drwopt(os[c],w);
							if (c<10) {   // Reset others
								for (d=0;d<10&&os[d].x!=-1;d++) {
									if (d!=c) {
										os[d].s=0;
										drwopt(os[d],w);
									}
								}
							}
							if (c>9&&c<20) {   // Reset others
								for (d=10;d<20&&os[d].x!=-1;d++) {
									if (d!=c) {
										os[d].s=0;
										drwopt(os[d],w);
									}
								}
							}
							if (c>19&&c<30) {   // Reset others
								for (d=20;d<30&&os[d].x!=-1;d++) {
									if (d!=c) {
										os[d].s=0;
										drwopt(os[d],w);
									}
								}
							}
							if (c>29&&c<40) {   // Reset others
								for (d=30;d<40&&os[d].x!=-1;d++) {
									if (d!=c) {
										os[d].s=0;
										drwopt(os[d],w);
									}
								}
							}
						}
						if (os[c].Q==TXTB) {
							setcolor(15);
							outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,os[c].txt);
							os[c].txt[0]='\0';
							tt[0]='';
							tt[1]='\0'; u=0;
							d=0; e=(os[c].s-8)/6;   // How many will fit?
							setcolor(16);
							outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,"");
							while (u!=13) {
								u=getch();
								setcolor(15);  // Erase
								outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,tt);
								if (u!=8&&u!=0&&u!=13&&d<e) {
									tt[d]=u; tt[d+1]=''; tt[d+2]='\0';
									d++;
								}
								if (u==8&&d>0) {
									d--;
									tt[d]=''; tt[d+1]='\0';
								}
								setcolor(16);  // Display
								outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,tt);
							}
							setcolor(15);  // Erase
							outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,tt);
							tt[d]='\0'; strcpy(os[c].txt,tt);
							setcolor(16);  // Display
							outtextxy(os[c].x+w.x+4,os[c].y+w.y+2,os[c].txt);
						}
					}
				}
			}
		}
	}
	*w2=w;
	return nhit;
}

